#ifndef Gate_BASE_H
#define Gate_BASE_H

#include "GlobalDefines.h"
#include "Wire.h"

#define BASE_GATE_SIZE_X 100
#define BASE_GATE_SIZE_Y 80
#define ADDITONAL_INPUTS 20
#define INPUT_CIRCLE_SIZE qreal(5)
#define BORDER_OFFSET 20
#define DEFAULT_LINE_WIDTH 3
#define ENQUEUED_CIRCLE_WIDTH 20

#define COLOR_MAIN 0,0,0,255
#define COLOR_MAIN_SELECTED 200,0,200,255
#define COLOR_INPUT COLOR_MAIN
#define COLOR_INPUT_SELECTED 255,0,0,255
#define COLOR_OUTPUT COLOR_MAIN
#define COLOR_OUTPUT_SELECTED 0,0,255,255
#define COLOR_DEBUG 0,0,0,100
#define COLOR_DEBUG_SELECTED 0,255,0,100
#define COLOR_DEBUG_ERROR 255,0,0,200

#define GATE_DEFAULT_Z 0
#define WIRE_DEFAULT_Z 1
#define SELECTED_Z 2

class Wire;

typedef enum {
    gate_UNKNOWN	= 0,
    gate_INPUT 		= 1,
    gate_OUTPUT  	= 2,
    gate_XOR 		= 3,
    gate_XNOR 		= 4,
    gate_DFF 		= 5,
    gate_AND 		= 6,
    gate_NAND 		= 7,
    gate_OR 		= 8,
    gate_NOR 		= 9,
    gate_NOT 		= 10,
    gate_BUFFER  	= 11
} gType;

/* Generic gate object */
class Gate_BASE : public QGraphicsObject
{
        Q_OBJECT
    public:
        Gate_BASE(int gateID, gType type,
                    int numInputs, int gateLevel,
                    QGraphicsItem *parent = 0);
        ~Gate_BASE();

        QRectF boundingRect() const;
        QPainterPath shape() const;

        // paint() should be overwritten by child classes
        virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)=0;

        void setCanvasPosition(int x, int y);
        void setHighlight(bool state, QColor color);

        void reset(void);
        void setInputValue(int input, logicValue value, logicValue faultyValue);
        void setOutputValue(logicValue value, logicValue faultyValue);
        void setEnqueued(bool value);

        virtual void simulateToOutput()=0;

        // Variables
        int xSize, ySize;
        QPoint canvasPoint;

        int gateID;
        gType gateType;
        int numInputs;
        int gateLevel;

        QList<logicValue> inputValues;
        QList<logicValue> inputFaultyValues;
        logicValue outputValue;
        logicValue outputFaultyValue;

        QList<Gate_BASE*> fanInGates;
        QList<Gate_BASE*> fanOutGates;
        QList<QPointF> gateInputPoints; // Scene inputs
        QPointF gateOutputPoint;		// Scene outputs

        QList<Wire*> gateInputWires;
        QList<Wire*> gateOutputWires;

    signals:
        void updateStatus(QString status);
        void enqueueSim(Gate_BASE *gate);

    public slots:

    protected:
        virtual void mousePressEvent(QGraphicsSceneMouseEvent *event);

        bool auxSelected;
        bool enqueued;

        // 'Local' points for I/O
        QList<QPointF> inputPoints;
        QPointF outputPoint;

        QPen defaultPen;
        QBrush defaultBrush;
        QFont defaultFont;

        QPen selectedPen;
        QPen highlightedPen;

        QRectF textRect;

#ifdef _DEBUG
        QPen debugPen;
        QBrush debugBrush;
        QPen debugSelectedPen;
        QPen debugErrorPen;
#endif
};

#endif // Gate_BASE_H
